//------------------------------------------------------------------------------------------------------------------------------------------------
// PA2 Extras - Adjust Spawns
//------------------------------------------------------------------------------------------------------------------------------------------------
// Author: RicTheCoder
//
// Simple script to adjust the spawn rate of some entities, TO BE LOWER, it can't increase it unfortunately. It is mainly to fix spawns that
// are too frequent and cause issues with other spawns, or make certain things slightly unplayable
//------------------------------------------------------------------------------------------------------------------------------------------------

// List of mobs to adjust their spawn chance
// - Read it as, when they are going to spawn, what is the chance of success?
const mobSpawnRate = {
	// These mobs make it almost impossible to do somethings in the end if you let too many spawn and get surrounded
	// So the chance is lowered to only 60% of the spawns actually succeed
	"outer_end:sinker": 0.60
}

//---[CODE]---------------------------------------------------------------------------------------------------------------------------------------

// SpawnRate Function
function recheckSpawn(event, mob) {
	// This condition makes the rate always be % + ~0.01% give or take, due to the way Random's are generated in most code languages.
	if (Math.random() > mobSpawnRate[mob])
		event.cancel();
};

// Registers the spawn check for each mob
Object.keys(mobSpawnRate).forEach(mob => {
	// The event is registered individually to prevent making the processing heavier by going through all mobs always.
	EntityEvents.checkSpawn(mob, event => recheckSpawn(event, mob));
});